<?php
require 'config.php';

$register_error = '';
$register_success = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['register'])) {
    $name = $conn->real_escape_string($_POST['name']);
    $email = $conn->real_escape_string($_POST['email']);
    $password = $_POST['password'];
    $password_confirm = $_POST['password_confirm'];
    
    if (strlen($password) < 6) {
        $register_error = "Password must be at least 6 characters long";
    } else if ($password !== $password_confirm) {
        $register_error = "Passwords do not match";
    } else {
        $check = $conn->query("SELECT * FROM users WHERE email = '$email'");
        if ($check->num_rows == 0) {
            $pass_hash = password_hash($password, PASSWORD_BCRYPT);
            if ($conn->query("INSERT INTO users (name, email, password, role) VALUES ('$name', '$email', '$pass_hash', 'user')")) {
                $register_success = "Account created successfully! Please login.";
            } else {
                $register_error = "Error creating account. Please try again.";
            }
        } else {
            $register_error = "Email already registered";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register - SourceHub</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        header {
            position: fixed;
            top: 0;
            width: 100%;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 15px;
            align-items: center;
        }
        
        .nav-links a {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            transition: all 0.3s;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 40px;
            max-width: 400px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
            margin-top: 80px;
        }
        
        .form-container h2 {
            text-align: center;
            margin-bottom: 30px;
            color: #2c3e50;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #bdc3c7;
            border-radius: 5px;
            font-size: 14px;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 5px rgba(102, 126, 234, 0.3);
        }
        
        .btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            transition: all 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid;
        }
        
        .alert-error {
            background: #fadbd8;
            color: #c0392b;
            border-left-color: #c0392b;
        }
        
        .alert-success {
            background: #d5f4e6;
            color: #27ae60;
            border-left-color: #27ae60;
        }
        
        .login-link {
            text-align: center;
            margin-top: 20px;
        }
        
        .login-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: bold;
        }
        
        @media (max-width: 768px) {
            .form-container {
                margin: 80px 20px 0;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <a href="login.php">Login</a>
            </div>
        </nav>
    </header>

    <div class="form-container">
        <h2>Create New Account</h2>
        
        <?php if ($register_error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($register_error); ?></div>
        <?php endif; ?>
        
        <?php if ($register_success): ?>
            <div class="alert alert-success">
                <?php echo htmlspecialchars($register_success); ?>
                <br><a href="login.php" style="color: #27ae60; font-weight: bold;">Click here to login</a>
            </div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label>Full Name</label>
                <input type="text" name="name" required>
            </div>
            <div class="form-group">
                <label>Email Address</label>
                <input type="email" name="email" required>
            </div>
            <div class="form-group">
                <label>Password</label>
                <input type="password" name="password" required>
            </div>
            <div class="form-group">
                <label>Confirm Password</label>
                <input type="password" name="password_confirm" required>
            </div>
            <button type="submit" name="register" class="btn">Create Account</button>
        </form>
        
        <div class="login-link">
            Already have an account? <a href="login.php">Login here</a>
        </div>
    </div>
</body>
</html>
